# change [PATH] accordingly to parent directory of files! 
setwd("[PATH]")
rm(list=ls(all=TRUE))

library(magrittr)
library(network)
library(GGally)
library(ggplot2)
library(grid)
library(dplyr)

# load network data
poc_network <- read.csv("./PoC RES Mentions DATA.csv")
poc_network$V1 <- as.factor(poc_network$V1)
poc_network$V2 <- as.factor(poc_network$V2)
poc_network <- network(poc_network, directed = T)

# combine with data on UNSC resolutions, normalize topics and build groups
load("./UNSC_Resolutions.RData")
poc.resolutions <- data.frame(Resolutions = network.vertex.names(poc_network))
poc.resolutions <- rename(poc.resolutions, Number=Resolutions)
resolutions$Topic[resolutions$Topic=="Report Of The Secretary-General On The Sudan"] <- "Sudan"
resolutions$Topic[resolutions$Topic=="Reports Of The Secretary-General On The Sudan"] <- "Sudan"
resolutions$Topic[resolutions$Topic=="Chad, The Central African Republic And The Subregion"] <- "Chad"
resolutions$Topic[resolutions$Topic=="The Question Concerning Haiti"] <- "Haiti"
resolutions$Topic[resolutions$Topic=="Sudan/South Sudan"] <- "South Sudan"
resolutions$Topic[resolutions$Topic=="Sudan Sanctions"] <- "Sudan"
resolutions$Topic[resolutions$Topic=="Peace And Security In Africa"] <- "Africa"
resolutions$Topic[resolutions$Topic=="Reports Of The Secretary-General On The Sudan And South Sudan"] <- "South Sudan"
resolutions$Topic[!resolutions$Topic %in% c("Protection Of Civilians In Armed Conflict", "Sierra Leone", "Democratic Republic Of The Congo", "Côte D'Ivoire", "Haiti", "Burundi", "Sudan", "Afghanistan",
                        "Somalia", "Chad", "Liberia", "Timor-Leste", "Libya", "Haiti", "Central African Republic",
                        "Mali", "South Sudan")] <- "Topical and Regional Agenda Items"
resolutions$Topic <- as.factor(resolutions$Topic)
poc.grp <- merge(resolutions, poc.resolutions, by = "Number")$Topic

# specify color set for visualization
colors <- c("#e41a1c", "#e41a1c", "#e41a1c", "#e41a1c", "#e41a1c", "#e41a1c", "#e41a1c", 
             "#e41a1c", "#e41a1c", "#e41a1c", "#31a354", "#e41a1c", "#e41a1c", "#e41a1c", 
             "#e41a1c", "#e41a1c", "#000000")

# build the network graph
ggnet(poc_network, size = 12, alpha = 0.3, mode = "kamadakawai", node.group = poc.grp, node.color = colors,
      label.nodes = T, segment.size = 1, label.size = 5) + 
  theme(legend.text = element_text(family = "Helvetica Neue", size = 14))
